/*
 * Decompiled with CFR 0.152.
 */
package net.smartkomm.gui;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import net.smartkomm.ChangeListenerThread;
import net.smartkomm.CheckLatestVersionThread;
import net.smartkomm.SyncThread;
import net.smartkomm.gui.PanelImage;
import net.smartkomm.gui.panelButtons;
import net.smartkomm.gui.panelConnector;
import net.smartkomm.gui.panelSWP;
import net.smartkomm.gui.panelStatus;
import net.smartkomm.gui.panelUntis;

public class CentralFrame
extends Frame {
    public static final String version_str = "202406.0";
    public static final String copyright = "Copyright (c) 2014-2024 SmartKomm GmbH, SWOP Untis Connector, Version 202406.0";
    Panel buttons;
    public panelStatus status;
    Panel untis;
    Panel swp;
    Panel connector;
    public Properties properties;
    public Date last_sync;
    public static ChangeListenerThread clt;
    public SyncThread st;
    public static final String config_key_swp_key = "swp_api_key";
    public static final String config_key_swp_url = "swp_url";
    public static final String config_key_untis = "untis_gpn_datei";
    public static final String config_connector_hintergrund = "connector_im_hintergrund";
    public static final String config_connector_automatisch = "connector_automatisch_synchronisieren";
    public static final String properties_filename = "smartkomm-schul-webportal-untis-connector.properties";
    private Button buttonExit;
    private Button buttonSync;
    private Label lVersion;
    private Panel panel1;
    private Panel panelContainer;
    private Panel panelMain;
    private Panel panelSync;

    public void showPanel(String string) {
        this.panelContainer.removeAll();
        this.buttonSync.setEnabled(false);
        if (string.equalsIgnoreCase("status")) {
            this.status.updateStatus();
            this.panelContainer.add((Component)this.status, "West");
            this.panelContainer.add((Component)this.buttons, "East");
            this.buttonSync.setEnabled(true);
            if (!this.getProperty(config_connector_automatisch).equalsIgnoreCase("true")) {
                this.status.setNextSync("nicht automatisch");
            }
        }
        if (string.equalsIgnoreCase("untis")) {
            this.panelContainer.add((Component)this.untis, "West");
        }
        if (string.equalsIgnoreCase("swp")) {
            this.panelContainer.add((Component)this.swp, "West");
        }
        if (string.equalsIgnoreCase("connector")) {
            this.panelContainer.add((Component)this.connector, "West");
        }
        if (this.getProperty(config_connector_hintergrund).equalsIgnoreCase("true")) {
            this.buttonExit.setLabel("In Hintergrund");
        } else {
            this.buttonExit.setLabel("Beenden");
        }
        if (this.getProperty(config_connector_automatisch).equalsIgnoreCase("true")) {
            if (clt == null) {
                clt = new ChangeListenerThread(this);
                clt.start();
            }
        } else if (clt != null) {
            clt.stop_now();
            clt = null;
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void loadPropertiesFile() {
        File file = new File(properties_filename);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.properties = new Properties();
            this.properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveProperty(String string, String string2) {
        try {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.setProperty(string, string2);
            File file = new File(properties_filename);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.properties.store(fileOutputStream, "SmartKomm Schul-Webportal Untis-Connector");
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getProperty(String string) {
        if (this.properties == null) {
            return "";
        }
        String string2 = this.properties.getProperty(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public CentralFrame() {
        this.loadPropertiesFile();
        if (this.getProperty(config_connector_automatisch).equalsIgnoreCase("true")) {
            clt = new ChangeListenerThread(this);
            clt.start();
        }
        PanelImage panelImage = new PanelImage("banner-untis-connector.png");
        this.add(panelImage);
        this.buttons = new panelButtons(this);
        this.buttons.setPreferredSize(new Dimension(250, 300));
        this.status = new panelStatus(this);
        this.status.setPreferredSize(new Dimension(600, 300));
        this.untis = new panelUntis(this);
        this.untis.setPreferredSize(new Dimension(600, 300));
        this.swp = new panelSWP(this);
        this.swp.setPreferredSize(new Dimension(600, 300));
        this.connector = new panelConnector(this);
        this.connector.setPreferredSize(new Dimension(600, 300));
        this.initComponents();
        this.panelContainer.add((Component)this.status, "Center");
        this.panelContainer.add((Component)this.buttons, "East");
        if (this.getProperty(config_connector_hintergrund).equalsIgnoreCase("true")) {
            this.buttonExit.setLabel("In Hintergrund");
        } else {
            this.buttonExit.setLabel("Beenden");
        }
        this.showPanel("status");
        this.lVersion.setText(copyright);
        CheckLatestVersionThread checkLatestVersionThread = new CheckLatestVersionThread(this);
        checkLatestVersionThread.start();
    }

    private void initComponents() {
        this.panelMain = new Panel();
        this.panel1 = new Panel();
        this.panelContainer = new Panel();
        this.panelSync = new Panel();
        this.buttonSync = new Button();
        this.buttonExit = new Button();
        this.lVersion = new Label();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CentralFrame.this.exitForm(windowEvent);
            }
        });
        this.setLayout(new FlowLayout());
        this.panelMain.setName("");
        this.panelMain.setPreferredSize(new Dimension(1000, 400));
        this.panelMain.setLayout(new BorderLayout());
        this.panel1.setMinimumSize(new Dimension(50, 50));
        this.panel1.setPreferredSize(new Dimension(50, 50));
        this.panelMain.add((Component)this.panel1, "West");
        this.panelContainer.setMinimumSize(new Dimension(800, 400));
        this.panelContainer.setPreferredSize(new Dimension(800, 400));
        this.panelContainer.setLayout(new BorderLayout());
        this.panelMain.add((Component)this.panelContainer, "Center");
        this.panelSync.setMinimumSize(new Dimension(800, 98));
        this.panelSync.setPreferredSize(new Dimension(800, 100));
        this.panelSync.setLayout(new GridBagLayout());
        this.buttonSync.setFont(new Font("Dialog", 1, 18));
        this.buttonSync.setForeground(new Color(0, 0, 153));
        this.buttonSync.setLabel("Daten synchronisieren");
        this.buttonSync.setMinimumSize(new Dimension(300, 40));
        this.buttonSync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CentralFrame.this.buttonSyncActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.panelSync.add((Component)this.buttonSync, gridBagConstraints);
        this.buttonExit.setLabel("Beenden");
        this.buttonExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CentralFrame.this.buttonExitActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 26;
        this.panelSync.add((Component)this.buttonExit, gridBagConstraints);
        this.lVersion.setFont(new Font("Dialog", 0, 10));
        this.lVersion.setForeground(new Color(102, 102, 102));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.panelSync.add((Component)this.lVersion, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(20, 10, 0, 0);
        this.panelMain.add((Component)this.panelSync, "South");
        this.add(this.panelMain);
        this.pack();
    }

    public void activateSyncButton(boolean bl) {
        if (this.buttonSync != null) {
            this.buttonSync.setEnabled(bl);
        }
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    private void buttonExitActionPerformed(ActionEvent actionEvent) {
        if (this.getProperty(config_connector_hintergrund).equalsIgnoreCase("true")) {
            this.setVisible(false);
        } else {
            System.exit(0);
        }
    }

    private void buttonSyncActionPerformed(ActionEvent actionEvent) {
        this.st = new SyncThread(this);
        this.st.start();
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CentralFrame().setVisible(true);
            }
        });
    }
}

