/*
 * Decompiled with CFR 0.152.
 */
package net.smartkomm;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.smartkomm.gui.CentralFrame;

public class SyncThread
extends Thread {
    CentralFrame cf;
    URLConnection connection;
    boolean auchStundenplan = false;
    final String boundary = Long.toHexString(System.currentTimeMillis());
    public static final String api_path = "/admin/untis_anbindung_upload";
    String file2upload = "untis-connector-upload.zip";

    public SyncThread(CentralFrame centralFrame) {
        this.cf = centralFrame;
    }

    public void setAuchStundenplan() {
        this.auchStundenplan = true;
    }

    @Override
    public void run() {
        if (this.cf.status != null) {
            if (!this.auchStundenplan) {
                this.cf.status.setNextSync("Datenabgleich wird gestartet..");
            } else {
                this.cf.status.setNextSync("Datenabgleich mit Stundenplan wird gestartet..");
            }
        }
        this.cf.activateSyncButton(false);
        this.cf.last_sync = new Date();
        this.compressFile();
        this.uploadFile();
        int n = -1;
        if (this.connection != null) {
            for (int i = 0; i < 10; ++i) {
                if (this.auchStundenplan) {
                    this.cf.status.setSyncMessage("Synchronisiere Daten .. " + String.valueOf(i));
                } else {
                    this.cf.status.setSyncMessage("Synchronisiere Daten mit Stundenplan .. " + String.valueOf(i));
                }
                try {
                    n = ((HttpURLConnection)this.connection).getResponseCode();
                }
                catch (IOException iOException) {
                    Logger.getLogger(SyncThread.class.getName()).log(Level.SEVERE, null, iOException);
                }
                System.out.println(n);
                if (n != -1) break;
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Logger.getLogger(SyncThread.class.getName()).log(Level.SEVERE, null, interruptedException);
                }
            }
        }
        if (n == 200) {
            this.cf.status.setSyncMessage("OK");
            this.cf.last_sync = new Date();
        } else {
            this.cf.status.setSyncMessage("Fehler: " + n);
        }
        this.cf.activateSyncButton(true);
        if (!this.cf.getProperty("connector_automatisch_synchronisieren").equalsIgnoreCase("true")) {
            this.cf.status.setNextSync("nicht automatisch");
        } else {
            this.cf.status.setNextSync("Warte auf \u00c4nderungen in Untis..");
        }
    }

    private void compressFile() {
        System.out.println("compressFile");
        if (this.cf.getProperty("untis_gpn_datei").endsWith("lesson.txt")) {
            System.out.println("compressFile not compressing, detected lesson.txt");
            this.file2upload = this.cf.getProperty("untis_gpn_datei");
            return;
        }
        System.out.println("compressFile compressing.. ");
        byte[] byArray = new byte[1024];
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file2upload);
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);){
                int n;
                ZipEntry zipEntry = new ZipEntry("untis-connector-upload.txt");
                zipOutputStream.putNextEntry(zipEntry);
                FileInputStream fileInputStream = new FileInputStream(this.cf.getProperty("untis_gpn_datei"));
                while ((n = fileInputStream.read(byArray)) > 0) {
                    zipOutputStream.write(byArray, 0, n);
                }
                fileInputStream.close();
                zipOutputStream.closeEntry();
                zipOutputStream.close();
                System.out.println("Done");
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(SyncThread.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFile() {
        System.out.println("uploadFile");
        try (PrintWriter printWriter = null;){
            int n;
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            System.setProperty("sun.security.ssl.allowUnsafeRenegotioation", "true");
            System.setProperty("java.net.useSystemProxies", "true");
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
            this.connection = new URL(this.cf.getProperty("swp_url") + api_path).openConnection();
            this.connection.setDoOutput(true);
            this.connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
            OutputStream outputStream = this.connection.getOutputStream();
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            printWriter.print("--" + this.boundary);
            printWriter.print("\r\n");
            printWriter.print("Content-Disposition: form-data; name=\"api_key\"");
            printWriter.print("\r\n");
            printWriter.print("Content-Type: text/plain; charset=UTF-8");
            printWriter.print("\r\n");
            printWriter.print("\r\n");
            printWriter.print(this.cf.getProperty("swp_api_key"));
            printWriter.print("\r\n");
            printWriter.print("--" + this.boundary);
            printWriter.print("\r\n");
            String string = "import_stundenplan";
            printWriter.print("Content-Disposition: form-data; name=\"" + string + "\"");
            printWriter.print("\r\n");
            printWriter.print("Content-Type: text/plain; charset=UTF-8");
            printWriter.print("\r\n");
            printWriter.print("\r\n");
            printWriter.print("true");
            printWriter.print("\r\n");
            printWriter.print("--" + this.boundary);
            printWriter.print("\r\n");
            printWriter.print("Content-Disposition: form-data; name=\"datafile\"; filename=\"" + this.file2upload + "\"");
            printWriter.print("\r\n");
            printWriter.print("\r\n");
            printWriter.flush();
            byte[] byArray = this.readBinaryFile(this.file2upload);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            byte[] byArray2 = new byte[4096];
            while ((n = byteArrayInputStream.read(byArray2)) > 0) {
                outputStream.write(byArray2, 0, n);
            }
            outputStream.flush();
            printWriter.print("--" + this.boundary + "--");
            printWriter.print("\r\n");
            printWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBinaryFile(String string) {
        File file = new File(string);
        byte[] byArray = new byte[(int)file.length()];
        try (InputStream inputStream = null;){
            int n = 0;
            inputStream = new BufferedInputStream(new FileInputStream(file));
            while (n < byArray.length) {
                int n2 = byArray.length - n;
                int n3 = inputStream.read(byArray, n, n2);
                if (n3 <= 0) continue;
                n += n3;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(SyncThread.class.getName()).log(Level.SEVERE, null, fileNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger(SyncThread.class.getName()).log(Level.SEVERE, null, iOException);
        }
        return byArray;
    }
}

